/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.sysutils.OperatingSystem;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class VWHelpCore {
    private static final int MODE_APPLET = 0;
    private static final int MODE_APPLICATION = 1;
    private int m_nMode = -1;
    private Vector m_appletReferences = null;
    private URL m_baseHelpURL = null;
    private String m_baseHelpPrefix = null;
    private String m_helpCommand = null;

    public void init(JApplet applet) {
        try {
            if (applet == null) {
                return;
            }
            if (this.m_appletReferences == null) {
                this.m_appletReferences = new Vector();
            }
            this.m_nMode = 0;
            this.m_appletReferences.addElement(applet);
            String helpPath = applet.getParameter("documentServerURL");
            if (helpPath != null && helpPath.length() > 0) {
                if (!helpPath.endsWith("/")) {
                    helpPath = helpPath + "/";
                }
            } else {
                String customHelpPath;
                helpPath = this.getBaseURL(applet);
                if (helpPath != null && (customHelpPath = applet.getParameter("helpPath")) != null && customHelpPath.length() > 0) {
                    helpPath = helpPath + customHelpPath;
                }
            }
            if (helpPath != null) {
                String sOldPlugin = null;
                boolean bOldPlugin = false;
                if (helpPath.endsWith(VWHelp.Help_P8_Doc)) {
                    bOldPlugin = true;
                    sOldPlugin = VWHelp.Help_P8_Doc;
                } else if (helpPath.endsWith(VWHelp.Help_P8_XT_User_Doc)) {
                    bOldPlugin = true;
                    sOldPlugin = VWHelp.Help_P8_XT_User_Doc;
                }
                if (bOldPlugin) {
                    int endIndex = helpPath.length() - sOldPlugin.length();
                    helpPath = helpPath.substring(0, endIndex);
                }
                this.m_baseHelpURL = new URL(helpPath);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(JFrame frame) {
        this.m_nMode = 1;
        this.m_helpCommand = System.getProperty("filenet.vw.toolkit.utils.VWHelpCore.helpcmd");
        if (this.m_helpCommand == null) {
            this.m_helpCommand = OperatingSystem.isWindows() ? "cmd /c start" : "mozilla";
        }
        this.m_baseHelpPrefix = System.getProperty("WF_HELP");
        if (this.m_baseHelpPrefix != null && this.m_baseHelpPrefix.length() > 0) {
            char testChar = this.m_baseHelpPrefix.charAt(this.m_baseHelpPrefix.length() - 1);
            if (testChar != File.separatorChar && testChar != '/') {
                this.m_baseHelpPrefix = this.m_baseHelpPrefix + File.separator;
            }
            if ((testChar = this.m_baseHelpPrefix.charAt(this.m_baseHelpPrefix.length() - 1)) != File.separatorChar && testChar != '/') {
                this.m_baseHelpPrefix = this.m_baseHelpPrefix + File.separator;
            }
        } else {
            this.m_baseHelpPrefix = System.getProperty("user.dir") + File.separator;
            this.m_baseHelpPrefix = this.m_baseHelpPrefix.concat("help" + File.separator);
        }
    }

    public void cleanUp(JApplet applet) {
        try {
            if (this.m_appletReferences != null) {
                this.m_appletReferences.remove(applet);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayPage(String page) {
        switch (this.m_nMode) {
            case 0: {
                this.displayHelpFromApplet(page);
                break;
            }
            case 1: {
                this.displayHelpFromApplication(page);
            }
        }
    }

    public String getBaseURL(JApplet applet) {
        try {
            if (applet == null) {
                return null;
            }
            if (applet instanceof VWBaseAppLauncherApplet) {
                return ((VWBaseAppLauncherApplet)applet).getBaseURL();
            }
            String baseURL = applet.getParameter("baseURL");
            if (baseURL != null) {
                return baseURL;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void displayHelpFromApplet(String page) {
        block4: {
            try {
                if (this.m_baseHelpURL == null) {
                    return;
                }
                URL helpURL = new URL(this.m_baseHelpURL + page);
                if (this.m_appletReferences == null) break block4;
                for (int nIndex = 0; nIndex < this.m_appletReferences.size(); ++nIndex) {
                    JApplet applet = (JApplet)this.m_appletReferences.elementAt(nIndex);
                    if (applet == null || !applet.isActive() || applet.getAppletContext() == null) continue;
                    applet.getAppletContext().showDocument(helpURL, "_blank");
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog((Frame)null, ex.getMessage(), 1);
            }
        }
    }

    private void displayHelpFromApplication(String page) {
        try {
            String helpPath = this.m_baseHelpPrefix.concat(page);
            if (helpPath.indexOf(" ") != -1) {
                helpPath = "\"" + helpPath + "\"";
            }
            Runtime.getRuntime().exec(this.m_helpCommand + " " + helpPath);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog((Frame)null, ex.getMessage(), 1);
        }
    }
}

